#include <components/Cube.h>
#include <components/Cylinder.h>
#include <core/IndentWriter.h>
#include <core/Difference.h>
#include <core/Union.h>
#include <core/Intersection.h>
#include <components/RoundedTablet.h>
#include <components/Sphere.h>


#include <iostream>
#include <fstream>


using namespace std;


int main(int argc, char **argv)
{
    IndentWriter writer1,writer2, writer3;

    ofstream os1("/Users/Nicuma/RockerBlotter.scad");   //Here you should use your own directory
    ofstream os2("/Users/Nicuma/ElegantHolder.scad");
    ofstream os3("/Users/Nicuma/RockerBlotter&Holder.scad");


    //Independent Parameters

    double  w=30,           //Widht (30)
            long_d=80,      //Recommended diameter: > 55   (80)
            e=2.5;          //Recommended thickness: 2-5 mm (2.5)



    //Dependent Parameters. Internal parametric calculus

    double rExt=long_d/2;


    //RockerBlotter base


    Component Square = (Cube::create(1.4142*rExt, 1.4142*rExt,w,true)
                        -Cube::create(1.4142*rExt-1.5*e, 1.4142*rExt-1.5*e,w+1,true)
                       );

    Component RockerBlotter = (Cylinder::create(rExt,w,100,true)
                                -Cylinder::create(rExt-e,w+1,100,true)
                                +Square
                                +Square.rotatedCopy(0,0,45)
                              )
                            -Cube::create(long_d+1,long_d/2,w+1,true).translate(0,long_d/4,0)
                            +Cube::create(long_d,e,w,true)
                            -Cube::create(long_d/2-long_d/20,e+5,w+1, true);

    Component Holder = Cube::create(long_d/2+long_d/16,3*e,w, true)
                      -Cube::create(long_d/10,e+2,w+1,true).translate(long_d/4,0,0)
                      -Cube::create(long_d/10,e+2,w+1,true).translate(-long_d/4,0,0)
                      +RoundedTablet(long_d/5,long_d/5,w,1,true,true,true,true,true).translate(0,e+long_d/16,0)
                      -RoundedTablet(-1.5*e+long_d/5,-1.5*e-1+long_d/5,w+1,1,true,true,true,true,true).translate(0,e+long_d/16+1,0);

    Component ElegantHolder = Cube::create(9*long_d/16,3*e,w, true)
                             -Cube::create(long_d/10,e+2,w+1,true).translate(long_d/4,0,0)
                             -Cube::create(long_d/10,e+2,w+1,true).translate(-long_d/4,0,0)
                             +Cube::create(1,e+3,w,true).translate(long_d/4+2,0,0)
                             +Cube::create(1,e+3,w,true).translate(-long_d/4-2,0,0)
                             +Cylinder::create(w/2-4,w/2-6, 3, 100, true).translate(0,0,2*e).rotate(90,0,0)
                             +Cylinder::create(w/4,w/5-1, 3, 100, true).translate(0,0,3*e).rotate(90,0,0)
                             +Cylinder::create(w/7, long_d/5, 100, true).translate(0,0,4*e).rotate(90,0,0)
                             +Cylinder::create(w/7,w/3.7-1,4, 100, true).translate(0,0,8*e).rotate(90,0,0)
                             +(Sphere::create (w/3.7-0.9,100,true).translate(0,0,8.3*e).rotate(90,0,0)
                             -Cube::create (w,true).translate(0,0,2.8*e).rotate(90,0,0));


    //Outputs

    writer1<<RockerBlotter;
    writer2<<ElegantHolder;
    writer3<< RockerBlotter+Holder.translate(0,-rExt/5,0);



    // Generating files

    if (os1){
            os1 << writer1;
            os1.close();
            cout << "Your file 'RockerBlotter' is ready." << endl;
            }
    else{
            cerr << "Error. File 'RockerBlotter' not generated." << endl;
        }



    if (os2){
            os2 << writer2;
            os2.close();
            cout << "Your file 'ElegantHolder' is ready." << endl;
            }
    else{
            cerr << "Error. File 'ElegantHolder' not generated." << endl;
        }



    if (os3){
            os3 << writer3;
            os3.close();
            cout << "Your file 'RockerBlotter&Holder' is ready." << endl;
            }
    else{
            cerr << "Error. File 'RockerBlotter&Holder' not generated." << endl;
        }

        return 0;
}
